package net.kldp.logviewer.common.collection;


import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/**
 * collection ü ϰ ϱ   util class
 * 
 */
public class BasicBox extends HashMap {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2937666855050134443L;
	protected String name = null;
	
	public BasicBox() {}
	
    /**
     * Ķͷ name ޾ variable settingѴ.
	 * @param name String
	 */
	public BasicBox(String name) {
		super();
		this.name = name;
	}
	
	/** 
	 * BasicBox ü  ο BasicBoxü Ͽ returnѴ.
	 * @return BasicBox Instance  
	 */
    public Object clone() {

		BasicBox newbox = new BasicBox(name);

		HashMap src    = (HashMap)this;
		HashMap target = (HashMap)newbox;
		
		
		for( Iterator e = src.keySet().iterator() ; e.hasNext() ; ){
			
			String key   = (String) e.next();
			Object value = src.get( key );
			target.put( key,value );
		
		}		
		
		return newbox;
	}
	
    /** 
     * BasicBoxü EntityClass   Ҷ ϴ.
     * BasicBoxü Attribute name entity Ŭ ʵ 
     * ʵ type ´ Data  entity Ŭ ʵ带 ä.
     * @param entity Entity Object
     */
	public void copyToEntity(Object entity) {
		
		if ( entity == null ) {
			throw new NullPointerException( "entity null" );
		}
	
		Class c = entity.getClass();
		Field [] field = c.getFields();
		for (int i=0 ; i<field.length; i++) {
			try {
				String fieldtype = field[i].getType().getName();
				String fieldname = field[i].getName();
				
				if ( containsKey( fieldname ) ) {
					if (fieldtype.equals("java.lang.String")) {
						field[i].set(entity, getString(fieldname));
					} else if (fieldtype.equals("int")) {
						field[i].setInt(entity, getInt(fieldname));
					} else if (fieldtype.equals("double")) {
						field[i].setDouble(entity, getDouble(fieldname));
					} else if (fieldtype.equals("long")) {
						field[i].setLong(entity, getLong(fieldname));
					} else if (fieldtype.equals("float")) {
						field[i].set(entity, new Float(getDouble(fieldname)));
					} else if (fieldtype.equals("boolean")) {
						field[i].setBoolean(entity, getBoolean(fieldname));
					} //end if ( fieldtype.equals("java.lang.String")) 
				} // end if ( containsKey( fieldname ) )
				 
			} catch(Exception e){
				//Debug.warn.println(this, e.getMessage());
			}
		}
	}
	
    /** 
    * ޹ key شǴ Value ڿ returnѴ.
    * ο getString() ̿Ͽ Ǿ ִ.
    * @param key String
    * @return java.lang.String
    */
	public String get(String key) {
		return getString(key);
	}
	
	/**
	 * ޹ key شǴ Value java.util.DateŸ returnѴ.
	 * 
	 * @param key
	 * @return
	 */
	public Date getDate(String key) {
		Date value = null;
		
		try {
			value = getTimestamp(key, "yyyyMMdd");
		} catch(Exception e) {
			value = null;
		}
		
		return value;
	}
	
	/**
	 * ޹ key شǴ Value java.util.DateŸ returnѴ.
	 * 
	 * @param key
	 * @return
	 */
	public Date getDateTime(String key) {
		Date value = null;
		
		try {
			value = getTimestamp(key, "yyyyMMdd HH:mm");
		} catch(Exception e) {
			value = null;
		}
		
		return value;
	}	
	
	/**
	 *  ޹ key شǴ Value Object returnѴ.
	 * 
	 * @param key
	 * @return
	 */
	public Object getObject(String key) {
		Object o = null;
		try {
			o = (Object)super.get(key);
		} catch(Exception e) {
			o = null;
		}
		
		return o;
	}
	
    /** 
    * ޹ key شǴ Value booleanreturnѴ.
    * @param key String
    * @return boolean
    */
	public boolean getBoolean(String key) {
		String value = getString(key);
		boolean isTrue = false;
		try {
			isTrue = (new Boolean(value)).booleanValue();
		} catch(Exception e){}
		
		return isTrue;
	}
	
    /** 
    * ޹ key شǴ Value double returnѴ.
    * @param key String
    * @return double
    */
	public double getDouble(String key) {
		String value = removeComma(getString(key));
		if ( value.equals("") ) {
			return 0;
		}
		
		double num = 0;
		try {
			num = Double.valueOf(value).doubleValue();
		} catch(Exception e) {
			num = 0;
		}
		
		return num;
	}
	
	/** 
	* ޹ key شǴ Value float returnѴ.
	* @param key String
	* @return float
	*/
	public float getFloat(String key) {
		return (float)getDouble(key);
	}
	
    /** 
    * ޹ key شǴ Value Int returnѴ.
    * @param key String
    * @return int
    */
	public int getInt(String key) {
		double value = getDouble(key);
		return (int)value;
	}
	
    /** 
    * ޹ key شǴ Value long returnѴ.
    * @param key String
    * @return long
    */
	public long getLong(String key) {
		String value = removeComma(getString(key));
		if ( value.equals("") ) {
			return 0L;
		}
		
		long lvalue = 0L;
		try {
			lvalue = Long.valueOf(value).longValue();
		} catch(Exception e) {
			lvalue = 0L;
		}
		
		return lvalue;
	}
	
	/** 
    * ޹ key شǴ Value String returnѴ.
    * @param key String
    * @return java.lang.String
    */
	public String getString(String key) {
		String value = null;
		
		try {
			Object o = (Object)super.get(key);
			Class c = o.getClass();
			
			if ( o == null ) {
				value = "";
			} else if( c.isArray() ) {
				int length = Array.getLength(o);
				if ( length == 0 ) {
					value = "";
				} else {
					Object item = Array.get(o, 0);
					if ( item == null ) {
						value = "";
					} else {
						value = item.toString();
					} // end if ( item == null )
				} // end if ( length == 0 )
			} else {
				value = o.toString();
			} // end if ( o == null )
			
		} catch(Exception e) {
			value = "";
		}
		
		return value;
	}
	
	/** 
	* ޹ key شǴ Value Timestamp returnѴ.
	* @param key String
	* @return Timestamp
	*/
	public java.sql.Timestamp getTimestamp(String key) {
		return getTimestamp(key,"yyyy-MM-dd");
	}

	/** 
	* ޹ key شǴ Value Timestamp returnѴ.
	* @param key String
	* @return Timestamp
	* @since 2006.01.02 
	*/
	public java.sql.Timestamp getTimestamp(String key, String strPattern) {

		String strDate = getString(key);
		String pattern = "yyyy-MM-dd HH:mm:ss";

		if (strDate.equals("")) return null;
		
		// pattern null̰ų "" ̸ ο  ԷѴ. 
		if (strPattern == null) strPattern="";
		if (!strPattern.equals("")) pattern = strPattern;

		try {
			java.text.SimpleDateFormat sd =
				new java.text.SimpleDateFormat(pattern);
			return new java.sql.Timestamp(sd.parse(strDate).getTime());
		} catch (java.text.ParseException e) {
			e.printStackTrace();
			return null;
		}
				
	}
	
	/** 
    * ޹ key شǴ Value Vector type returnѴ.
    * @param key String
    * @return java.util.Vector
    */
	public Vector getVector(String key) {
		
		Vector vector = new Vector();
		
		try {
			Object o = (Object)super.get(key);
			Class c = o.getClass();
			if ( o != null ) {
				if( c.isArray() ) {
					int length = Array.getLength(o);					
					if ( length != 0 ) {
						for(int i=0; i<length;i++) {	
							Object item = Array.get(o, i);
							if (item == null ) {
								vector.addElement("");
							} else {
								vector.addElement(item.toString());
							} // end if (item == null ) 
						} // end for(int i=0; i<length;i++)
					} // end if ( length != 0 )
					
				} else {
					vector.addElement(o.toString());
				} // end if( c.isArray() ) 
			} // end if ( o != null )
			
		} catch(Exception e) {}
		
		return vector;
	}
	
	/** 
    * ޹ key value Ѵ.
    * @param key String
    * @param value String
    */
	public void put(String key, String value) {
		super.put(key, value);
	}
	
	/** 
    * ޹ Vector key Vector Ѵ.
	* @param key java.lang.String
	* @param vector java.util.Vector
	*/
	public void putVector(String key, Vector vector) {
		
			String value[] = new String[vector.size()];
			for(int idx=0; idx<vector.size(); idx++)
			value[idx] = (vector.get(idx) == null ) ? "" : vector.get(idx).toString();
			put(key, value);
			
	}
	

	/** 
    * ޹ String ',' Ѵ  ڿ ȯѴ.
    * ݾ DATAó ϴ.
    * @param s String
    * @return java.lang.String
    */
	protected static String removeComma(String s) {
		if ( s == null ) {
			return null;
		}
		if ( s.indexOf(",") != -1 ) {
			StringBuffer buf = new StringBuffer();
			for(int i=0;i<s.length();i++) {
				char c = s.charAt(i);
				if ( c != ',') {
					buf.append(c);
				} // end if ( c != ',')
			}// end for(int i=0;i<s.length();i++) 
			
			return buf.toString();
		} // end if ( s.indexOf(",") != -1 )
		
		return s;
	}
	
	/** 
    * ش key value Ѵ.
    * @param key String
    * @param value String
    */
	public void set(String key, String value) {
		super.put(key, value);
	}
	
	/** 
    * ش key Vector Ѵ.
	* @param key java.lang.String
	* @param vector java.util.Vector
	*/
	public void setVector(String key, Vector vector) {
		
		String value[] = new String[vector.size()];
		for(int idx=0; idx<vector.size(); idx++)
		value[idx] = (vector.get(idx) == null ) ? "" : vector.get(idx).toString();
		put(key, value);
		
	}
	
	/** 
    * HttpServletRequest request  HashMap о
    * name value ڿ  returnѴ.
    * @return java.lang.String
    */
	public synchronized String toString() {
		int max = size() - 1;
		StringBuffer buf = new StringBuffer();

		// key set
		Iterator Keys = keySet().iterator();

		// value set
		Iterator values = entrySet().iterator();

		buf.append("{");
	
		for (int i = 0; i <= max; i++) {
			
			String key = (String)Keys.next();
			String value = null;
			Object o = values.next();
				
			if (o == null) {
				value = "";
				
			} else {
				Class  c = o.getClass();
				if(c.isArray()) {
					int length = Array.getLength(o);
					if (length == 0) {
						value = "";
					} else if (length == 1) {
						Object item = Array.get(o, 0);
						if ( item == null ) {
							value = "";
						} else {
							value = item.toString();
						} // end if ( item == null )
					} else {
						StringBuffer valueBuf = new StringBuffer();
						valueBuf.append("[");
						for ( int j=0; j<length; j++) {
							Object item = Array.get(o, j);
							if ( item != null ) {
								valueBuf.append(item.toString());
							}
							if ( j<length-1) {
								valueBuf.append(",");
							}
						} // end for ( int j=0;j<length;j++)
						
						valueBuf.append("]");
						value = valueBuf.toString();
					} // end if ( length == 0 )
					
				} else {
					value = o.toString();
				} // end if( c.isArray() )
			} // end if ( o == null )
			
		    buf.append(key + "=" + value);
		    if (i < max) {
		    	buf.append(", ");
		    }
		} // end for (int i = 0; i <= max; i++)
	    buf.append("}");
	
		return "BasicBox["+name+"]=" + buf.toString();
		
    }
    
    public static void main(String[] args) {
		BasicBox box = new BasicBox();
		box.put("aa", "2003-10-17");
		
		System.out.println( (box.getDate("aa")).toString());
    }

}
